/*
 * Decompiled with CFR 0.152.
 */
package apiipc.generated.events;

import apicore.message.IPCEventLTV;
import apicore.message.UUID;
import apicore.ptmp.PacketTracerSession;
import apiipc.generated.events.IPCManagerEvent;
import apiipc.generated.events.IPCManagerEventListener;
import apiipc.generated.system.IPCManager;
import apiipc.ipc.IPCEventRegistry;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IPCManagerEventRegistry
extends IPCEventRegistry {
    protected Set<IPCManagerEventListener> globalListeners = new HashSet<IPCManagerEventListener>();
    protected Map<String, Set<IPCManagerEventListener>> specificObjectListeners = new HashMap<String, Set<IPCManagerEventListener>>();

    public IPCManagerEventRegistry(PacketTracerSession packetTracerSession) {
        super(packetTracerSession);
    }

    @Override
    public String getClassName() {
        return "IpcManager";
    }

    @Override
    public void processEvent(IPCEventLTV iPCEventLTV) {
        String string = iPCEventLTV.getEventName();
        IPCManagerEvent iPCManagerEvent = null;
        if (string.equalsIgnoreCase("onSave")) {
            iPCManagerEvent = new IPCManagerEvent.OnSave(iPCEventLTV);
        } else if (string.equalsIgnoreCase("onOpen")) {
            iPCManagerEvent = new IPCManagerEvent.OnOpen(iPCEventLTV);
        } else {
            return;
        }
        for (IPCManagerEventListener object : this.globalListeners) {
            object.handleEvent(iPCManagerEvent);
        }
        Set<IPCManagerEventListener> set = this.specificObjectListeners.get(iPCManagerEvent.objectUUID.toString());
        if (set != null) {
            for (IPCManagerEventListener iPCManagerEventListener : set) {
                iPCManagerEventListener.handleEvent(iPCManagerEvent);
            }
        }
    }

    public void addListenerFiltered(IPCManagerEventListener iPCManagerEventListener, List<String> list) throws IOException {
        if (this.globalListeners.size() == 0) {
            if (list == null) {
                this.register("onSave");
                this.register("onOpen");
            } else {
                for (int i = 0; i < list.size(); ++i) {
                    this.register(list.get(i));
                }
            }
        }
        this.globalListeners.add(iPCManagerEventListener);
    }

    public void addSpecificListenerFiltered(IPCManagerEventListener iPCManagerEventListener, IPCManager iPCManager, List<String> list) throws IOException {
        UUID uUID = iPCManager.getObjectUUID();
        String string = uUID.toString();
        Set<IPCManagerEventListener> set = this.specificObjectListeners.get(string);
        if (set == null) {
            set = new HashSet<IPCManagerEventListener>();
            this.specificObjectListeners.put(string, set);
            if (list == null) {
                this.register(uUID, "onSave");
                this.register(uUID, "onOpen");
            } else {
                for (int i = 0; i < list.size(); ++i) {
                    this.register(uUID, list.get(i));
                }
            }
        }
        set.add(iPCManagerEventListener);
    }

    public void removeListenerFiltered(IPCManagerEventListener iPCManagerEventListener, List<String> list) throws IOException {
        if (this.globalListeners.size() != 0) {
            if (list == null) {
                this.deregister("onSave");
                this.deregister("onOpen");
            }
            this.globalListeners.remove(iPCManagerEventListener);
        }
    }

    public void removeSpecificListenerFiltered(IPCManagerEventListener iPCManagerEventListener, IPCManager iPCManager, List<String> list) throws IOException {
        UUID uUID = iPCManager.getObjectUUID();
        String string = uUID.toString();
        Set<IPCManagerEventListener> set = this.specificObjectListeners.get(string);
        if (set != null && !set.isEmpty()) {
            this.deregister(uUID, "onSave");
            this.deregister(uUID, "onOpen");
            set.remove(iPCManagerEventListener);
        }
    }

    public void addListener(IPCManagerEventListener iPCManagerEventListener) throws IOException {
        this.addListenerFiltered(iPCManagerEventListener, null);
    }

    public void addListener(IPCManagerEventListener iPCManagerEventListener, IPCManager iPCManager) throws IOException {
        this.addSpecificListenerFiltered(iPCManagerEventListener, iPCManager, null);
    }

    public void removeListener(IPCManagerEventListener iPCManagerEventListener) throws IOException {
        this.removeListenerFiltered(iPCManagerEventListener, null);
    }

    public void removeListener(IPCManagerEventListener iPCManagerEventListener, IPCManager iPCManager) throws IOException {
        this.removeSpecificListenerFiltered(iPCManagerEventListener, iPCManager, null);
    }
}

